-- Seed org units
INSERT INTO org_units (name) VALUES
('Kantor Region XI'),
('Unit A'),('Unit B'),('Unit C');

-- Seed users (TEMP passwords auto-upgrade on first login)
INSERT INTO users (full_name,email,password_hash,role,org_unit_id,is_active) VALUES
('Admin Carpool','admin@example.com','TEMP:Admin123!','admin',1,1),
('Driver One','driver@example.com','TEMP:Driver123!','driver',1,1),
('User Satu','user@example.com','TEMP:User123!','user',2,1);

-- Seed driver profile
INSERT INTO drivers (user_id, license_no, phone, is_active)
SELECT id, 'B1234567', '+62-811-000-111', 1 FROM users WHERE email='driver@example.com';

-- Seed vehicles
INSERT INTO vehicles (plate_no,label,type,seats,is_active) VALUES
('DK 1234 AB','Avanza Pool 1','MPV_ECO',7,1),
('DK 5678 CD','Innova Pool 2','MPV_MID',7,1),
('DK 9999 EF','Rush Pool 3','SUV_ECO',7,1);

-- Pair driver to a vehicle (start today)
INSERT INTO driver_vehicle_pairings (driver_id,vehicle_id,start_date,end_date,is_primary)
VALUES (
 (SELECT id FROM drivers LIMIT 1),
 (SELECT id FROM vehicles WHERE plate_no='DK 1234 AB'),
 CURDATE(), NULL, 1
);
