<?php
require __DIR__.'/../config/db.php';
require __DIR__.'/../config/auth.php';
require_login(); require_role(['admin']);

// quick stats
$pending = $pdo->query("SELECT COUNT(*) c FROM ride_requests WHERE status='PENDING'")->fetch()['c'];
$assigned = $pdo->query("SELECT COUNT(*) c FROM ride_requests WHERE status='ASSIGNED'")->fetch()['c'];
$completed = $pdo->query("SELECT COUNT(*) c FROM ride_requests WHERE status='COMPLETED'")->fetch()['c'];

$recent = $pdo->query("
SELECT r.id, r.vehicle_type, r.pickup_time, r.passenger_name, r.status,
  a.driver_id, v.plate_no
FROM ride_requests r
LEFT JOIN ride_assignments a ON a.ride_request_id=r.id
LEFT JOIN vehicles v ON v.id=a.vehicle_id
ORDER BY r.created_at DESC LIMIT 12")->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Admin Dashboard</title>
<link rel="stylesheet" href="/assets/style.css">
</head><body>
<header>
  <h2>Admin Dashboard</h2>
  <nav>
    <a href="/admin_master.php">Master Data</a>
    <a href="/request_new.php">Request (User)</a>
    <a href="/driver_jobs.php">Driver</a>
  </nav>
</header>

<div class="card">
  <b>Stats</b>
  <div>Pending: <span class="badge"><?= $pending ?></span> &nbsp;
       Assigned: <span class="badge"><?= $assigned ?></span> &nbsp;
       Completed: <span class="badge"><?= $completed ?></span></div>
  <form method="post" action="/api/assign_auto.php" style="margin-top:12px">
    <label>Assign Request ID</label>
    <input name="request_id" placeholder="e.g. 1" required>
    <button>Auto-Assign Now</button>
  </form>
</div>

<div class="card">
  <b>Recent Requests</b>
  <table class="table">
    <tr><th>ID</th><th>Type</th><th>Pickup</th><th>Passenger</th><th>Status</th><th>Plate</th></tr>
    <?php foreach($recent as $r): ?>
    <tr>
      <td><?= $r['id'] ?></td>
      <td><?= $r['vehicle_type'] ?></td>
      <td><?= $r['pickup_time'] ?></td>
      <td><?= htmlspecialchars($r['passenger_name']) ?></td>
      <td><?= $r['status'] ?></td>
      <td><?= $r['plate_no'] ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
</body></html>
